public class DbProductGateway : ProductGateway
{
  private readonly SqlConnection connection;

  public DbProductGateway(SqlConnection connection)
  {
    this.connection = connection;
  }
  public void Insert(Product product)
  {
    string sql = "insert into Products (sku, name, price)" +
      " values (@sku, @name, @price)";
    SqlCommand command = new SqlCommand(sql, connection);
    command.Parameters.Add("@sku", product.Sku);
    command.Parameters.Add("@name", product.Name);
    command.Parameters.Add("@price", product.Price);
    command.ExecuteNonQuery();
  }

  public Product Find(string sku)
  {
    string sql = "select * from Products where sku = @sku";
    SqlCommand command = new SqlCommand(sql, connection);
    command.Parameters.Add("@sku", sku);
    IDataReader reader = command.ExecuteReader();

    Product product = null;
    if(reader.Read())
    {
      string name = reader["name"].ToString();
      int price = Convert.ToInt32(reader["price"]);
      product = new Product(name, sku, price);
    }
    reader.Close();

    return product;
  }
}
